<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg="." version="1.0">
  <!--
BOSCH Security Sytems (Ottobrunn)

Project: Magic.Panel

Author: Michael Ziegel

Created: 12.09.2006

$Archive:   //ot1esw2/MagicPanel/PVCS MP-SW/archives/MP_SW/MP_PC_SW/Transformer/Conversion/XSLT/conv-lteq-1-1-0-to-gteq-1-2-0.xsl-arc  $  

$Revision: 1.7 $ 

Last locked:   $Date: 2008/10/06 10:23:33GMT $

Last change by $Author: Michael Ziegel (zi82ot) $

History: 
$Log: XSLT/conv-lt-1-3-0-to-1-3-0.xsl  $
Revision 1.7 2008/10/06 10:23:33GMT Michael Ziegel (zi82ot) 
Member moved from Conversion/XSLT/conv-lt-1-3-0-to-1-3-0.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj to XSLT/conv-lt-1-3-0-to-1-3-0.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/RPSTools/XMLSupport/XMLSupport.pj.
Revision 1.6 2008/10/06 12:23:33CEST Michael Ziegel (zi82ot) 
revision control added
Revision 1.5 2006/12/07 17:24:38CET zi82ot 
add elements autoDetectors
Revision 1.4 2006/11/28 18:31:45CET zi82ot 
generate redundantSiNumber in MTS
Revision 1.3 2006/09/28 12:43:28CEST zi82ot 
Conversions implemented
Revision 1.2 2006/09/18 12:16:52CEST zi82ot 
Appy new structure using includes

-->
  <cfg:Stylesheet version="$Revision: 1.7 $"/>
  <xsl:output method="xml" indent="yes"/>
  <xsl:include href="conv-lt-1-2-0-to-1-2-0.xsl"/>
  <xsl:variable name="NOT_TRANS" select="'Not Transmitted'"/>
  <!-- replace existing FAT_ADMIN by MTS_ADMIN and insert ADDRESSMANAGMENT after it in LOGICAL_GROUPING -->
  <xsl:template match="LOGICAL_GROUPING/FAT_ADMIN">
    <xsl:if test="FAT">
      <xsl:element name="MTS_ADMIN">
        <xsl:for-each select="FAT">
          <xsl:apply-templates select="."/>
        </xsl:for-each>
      </xsl:element>
      <xsl:element name="ADDRESS_MANAGEMENT">
        <xsl:call-template name="CreateGlobalOffsetTable"/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!--  new element MTS from old FAT-->
  <xsl:template match="FAT_ADMIN/FAT">
    <xsl:element name="MTS">
      <xsl:element name="subType">
        <xsl:choose>
          <xsl:when test="fat != $NOT_TRANS or coupler != $NOT_TRANS">
            <xsl:text>FMS</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>FAT</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
      <xsl:element name="siNumber">
        <xsl:value-of select="siNumber"/>
      </xsl:element>
      <xsl:element name="label">
        <xsl:value-of select="label"/>
      </xsl:element>
      <xsl:element name="redundantSiNumber">
      <xsl:text>0</xsl:text>
      </xsl:element>
      <xsl:element name="TRANSMISSION_TABLE">
        <xsl:for-each select="*">
          <xsl:choose>
            <xsl:when test="name() = 'UART' or name() = 'OB_UART' or name() = 'siNumber' or name() = 'label' or name() = 'connectedWith'">
              <!-- do nothing -->
            </xsl:when>
            <xsl:otherwise>
              <xsl:element name="{name()}">
                <xsl:choose>
                  <xsl:when test=". = $NOT_TRANS">
                    <xsl:text>ST_NO</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>ST_YES</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:element>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each>
      </xsl:element>
      <xsl:element name="MTS_CONNECTION">
        <xsl:element name="connectedWith">
          <xsl:value-of select="connectedWith"/>
        </xsl:element>
        <xsl:for-each select="*">
          <xsl:if test="name() = 'UART' or name() = 'OB_UART'">
            <xsl:element name="{name()}">
              <xsl:apply-templates/>
            </xsl:element>
          </xsl:if>
        </xsl:for-each>
        <xsl:call-template name="CreateProtocolValues"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- Create Protocol under MTS/MTS_CONNECTION -->
  <xsl:template name="CreateProtocolValues">
    <xsl:element name="PROTOCOL_4A">
      <xsl:element name="timerA">2000</xsl:element>
      <xsl:element name="timerB">2000</xsl:element>
      <xsl:element name="timerC">400</xsl:element>
      <xsl:element name="timerD">6000</xsl:element>
      <xsl:element name="timerLinecheck">5</xsl:element>
      <xsl:element name="retriesA">2</xsl:element>
      <xsl:element name="retriesC">20</xsl:element>
      <xsl:element name="isMaster">ST_YES</xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- Create GLOBAL_OFFSET_TABLE -->
  <xsl:template name="CreateGlobalOffsetTable">
    <xsl:element name="GLOBAL_OFFSET_TABLE">
      <xsl:element name="panel">
        <xsl:if test="FAT/panel != $NOT_TRANS">
          <xsl:value-of select="FAT/panel"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="point">
        <xsl:if test="FAT/point != $NOT_TRANS">
          <xsl:value-of select="FAT/point"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="module">
        <xsl:if test="FAT/module != $NOT_TRANS">
          <xsl:value-of select="FAT/module"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="coupler">
        <xsl:if test="FAT/coupler != $NOT_TRANS">
          <xsl:value-of select="FAT/coupler"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="control">
        <xsl:if test="FAT/control != $NOT_TRANS">
          <xsl:value-of select="FAT/control"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="input">
        <xsl:if test="FAT/input != $NOT_TRANS">
          <xsl:value-of select="FAT/input"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="citytie">
        <xsl:if test="FAT/citytie != $NOT_TRANS">
          <xsl:value-of select="FAT/citytie"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="fireextinguisher">
        <xsl:if test="FAT/fireextinguisher != $NOT_TRANS">
          <xsl:value-of select="FAT/fireextinguisher"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="nac">
        <xsl:if test="FAT/nac != $NOT_TRANS">
          <xsl:value-of select="FAT/nac"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="buzzer">
        <xsl:if test="FAT/buzzer != $NOT_TRANS">
          <xsl:value-of select="FAT/buzzer"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="hvac">
        <xsl:if test="FAT/hvac != $NOT_TRANS">
          <xsl:value-of select="FAT/hvac"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="doorholder">
        <xsl:if test="FAT/doorholder != $NOT_TRANS">
          <xsl:value-of select="FAT/doorholder"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="keydepot">
        <xsl:if test="FAT/keydepot != $NOT_TRANS">
          <xsl:value-of select="FAT/keydepot"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="status">
        <xsl:if test="FAT/status != $NOT_TRANS">
          <xsl:value-of select="FAT/status"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="dialer">
        <xsl:if test="FAT/dialer != $NOT_TRANS">
          <xsl:value-of select="FAT/dialer"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="printer">
        <xsl:if test="FAT/printer != $NOT_TRANS">
          <xsl:value-of select="FAT/printer"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="fat">
        <xsl:if test="FAT/fat != $NOT_TRANS">
          <xsl:value-of select="FAT/fat"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="fbf">
        <xsl:if test="FAT/fbf != $NOT_TRANS">
          <xsl:value-of select="FAT/fbf"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="set">
        <xsl:if test="FAT/set != $NOT_TRANS">
          <xsl:value-of select="FAT/set"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="auxpower">
        <xsl:if test="FAT/auxpower != $NOT_TRANS">
          <xsl:value-of select="FAT/auxpower"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="battery">
        <xsl:if test="FAT/battery != $NOT_TRANS">
          <xsl:value-of select="FAT/battery"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="mainpower">
        <xsl:if test="FAT/mainpower != $NOT_TRANS">
          <xsl:value-of select="FAT/mainpower"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="railpower">
        <xsl:if test="FAT/railpower != $NOT_TRANS">
          <xsl:value-of select="FAT/railpower"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="ground">
        <xsl:if test="FAT/ground != $NOT_TRANS">
          <xsl:value-of select="FAT/ground"/>
        </xsl:if>
      </xsl:element>
      <xsl:element name="loop">
        <xsl:if test="FAT/loop != $NOT_TRANS">
          <xsl:value-of select="FAT/loop"/>
        </xsl:if>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- add automaticDetectors -->
  <xsl:template match="GLTZONE/usageType">
    <xsl:element name="usageType">
      <xsl:value-of select="."/>
    </xsl:element>
    <!-- if not already there -->
    <xsl:if test="../automaticDetectors = false()"> 
    <xsl:element name="automaticDetectors">
      <xsl:text>ST_YES</xsl:text>
    </xsl:element>
   </xsl:if> 
  </xsl:template>
  <!-- add automaticDetectors -->
  <xsl:template match="GLTZONE_LSNI_CONV4/usageType">
    <xsl:element name="usageType">
      <xsl:value-of select="."/>
    </xsl:element>
    <!-- if not already there -->
    <xsl:if test="../automaticDetectors = false()"> 
    <xsl:element name="automaticDetectors">
      <xsl:text>ST_YES</xsl:text>
    </xsl:element>
   </xsl:if> 
  </xsl:template>
  <!-- add automaticDetectors -->
  <xsl:template match="GLTZONEKD/usageType">
    <xsl:element name="usageType">
      <xsl:value-of select="."/>
    </xsl:element>
    <!-- if not already there -->
    <xsl:if test="../automaticDetectors = false()"> 
    <xsl:element name="automaticDetectors">
      <xsl:text>ST_YES</xsl:text>
    </xsl:element>
   </xsl:if> 
  </xsl:template>
  <!-- add automaticDetectors -->
  <xsl:template match="DOW1171/sensitivity">
    <xsl:element name="sensitivity">
      <xsl:value-of select="."/>
    </xsl:element>
    <!-- if not already there -->
    <xsl:if test="../automaticDetector = false()"> 
    <xsl:element name="automaticDetector">
      <xsl:text>ST_YES</xsl:text>
    </xsl:element>
   </xsl:if> 
  </xsl:template>
</xsl:stylesheet>
